from cachetools import cached, TTLCache
import time

TTL = 1


class NotificationFilter(object):
	
	def __init__(self, ttl_value=3):
		"""init function
		"""
		global TTL
		TTL = ttl_value
		self.TTL = ttl_value
		self.face_id_cache = {}
	
	def _update_cache(self, name):
		"""updates the cache with a name

		Args:
			name (str): Name of the person
		"""
		self.face_id_cache[name] = time.time()
	
	def send_notification(self, name):
		"""Returns a boolean if the notification center has to be notified
		or not

		Args:
			name (str): name of person identified

		Returns:
			notify (bool): True if notification to be sent False if the
			notification is not to be sent
		"""
		self._clean_up_cache()
		if name is None:
			notify = False
		else:
			is_present = self.face_id_cache.get(name, -1)
			if is_present == -1:
				notify = True
				self._update_cache(name)
			else:
				notify = False
		return notify
	
	@cached(cache=TTLCache(maxsize=1024, ttl=TTL))
	def _clean_up_cache(self):
		"""Cleans up the cached name at regular interval
		"""
		key_to_delete = []
		for key, value in self.face_id_cache.items():
			if time.time() - value >= self.TTL:
				key_to_delete.append(key)
		for key in key_to_delete:
			del self.face_id_cache[key]


if __name__ == "__main__":
	obj = NotificationFilter()
	print(obj.send_notification("Litesh"))
	print(obj.send_notification("Litesh"))
	time.sleep(3)
	print(obj.send_notification("Litesh"))
	time.sleep(1)
	print(obj.send_notification("Litesh"))
