import socket

UDP_IP = 'localhost'
UDP_PORT = 5006
BUFFER_SIZE = 1024

# create UDP socket and bind to IP address and port
udp_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
udp_socket.bind((UDP_IP, UDP_PORT))

# create TCP socket to send packet back to original server
tcp_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
TCP_IP = 'localhost'
TCP_PORT = 5005
tcp_socket.connect((TCP_IP, TCP_PORT))

while True:
    # receive UDP packet
    data, addr = udp_socket.recvfrom(BUFFER_SIZE)
    print('Received data:', data)

    # send TCP packet to original server
    tcp_socket.send(data)

    # receive response from TCP server
    response = tcp_socket.recv(BUFFER_SIZE)
    print('Received response:', response)

    # encapsulate response in UDP packet and send back to client
    udp_socket.sendto(response, addr)

tcp_socket.close()
