import socket

TCP_IP = 'localhost'
TCP_PORT = 5005
BUFFER_SIZE = 1024

# create TCP socket and bind to IP address and port
tcp_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
tcp_socket.bind((TCP_IP, TCP_PORT))
tcp_socket.listen(1)

# create UDP socket
udp_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

while True:
    # accept incoming TCP connection
    conn, addr = tcp_socket.accept()
    print('Connection address:', addr)

    while True:
        # receive data from TCP connection
        data = conn.recv(BUFFER_SIZE)
        if not data: break
        print('Received data:', data)

        # encapsulate data in UDP packet and send to server
        udp_socket.sendto(data, ('localhost', 5006))

        # receive response from UDP server
        response, server_addr = udp_socket.recvfrom(BUFFER_SIZE)
        print('Received response:', response)

        # send response back to TCP client
        conn.send(response)

    # close TCP connection
    conn.close()
