from opcua import Client

url = "opc.tcp://klblrlp1437.corp.knowledgelens.com:53530/OPCUA/SimulationServer"
client = Client(url)
client.connect()

root = client.get_root_node()
objects = root.get_children()
for obj in objects:
    print(f"Object: {obj.get_browse_name()}")

    nodes = obj.get_children()
    for node in nodes:
        node_id = node.nodeid.Identifier
        identifier = node.get_browse_name().Name
        if(node_id==str('85/0:Simulation')):
            object_node = client.get_node(node)
            subnodes=node.get_children()
            for snode in subnodes:
                value = client.get_node(snode).get_value()
                print(value)
client.disconnect()
