import asyncio
import socket

from asyncua import Client, Node
from asyncua.common.subscription import DataChangeNotif, SubHandler

msgFromClient = "Hello UDP Server"
bytesToSend = str.encode(msgFromClient)
serverAddressPort = ("2.2.2.5", 20001)
bufferSize = 1024
UDPClientSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)

ENDPOINT = 'opc.tcp://2.2.2.7:53530/OPCUA/SimulationServer'
NAMESPACE = 'http://www.prosysopc.com/OPCUA/SimulationServer/'

class MyHandler(SubHandler):
    def __init__(self):
        self._queue = asyncio.Queue()

    def datachange_notification(self, node: Node, value, data: DataChangeNotif) -> None:
        self._queue.put_nowait([node, value, data])


    async def process(self) -> None:
        try:
            while True:
                [node, value, data] = self._queue.get_nowait()
                datatype = type(value)
                packet = str(datatype) + "&" + str(value) + "&" + 'ns=' + str(node.nodeid.NamespaceIndex) + ";i=" + str(node.nodeid.Identifier)
                UDPClientSocket.sendto(str.encode(packet), serverAddressPort)

        except asyncio.QueueEmpty:
            pass


async def get_nodes(client):
    subnodes = None
    root = client.get_root_node()
    objects = await root.get_children()
    for obj in objects:
        nodes = await obj.get_children()
        for node in nodes:
            node_id = node.nodeid.Identifier
            if (node_id == str('85/0:Simulation')):
                subnodes = await node.get_children()
    return subnodes


async def main() -> None:
    async with Client(url=ENDPOINT) as client:
        # Get a variable node.
        node = await get_nodes(client)
        # Subscribe data change.
        handler = MyHandler()
        subscription = await client.create_subscription(period=0, handler=handler)
        await subscription.subscribe_data_change(node)

        # Process data change every 100ms
        while True:
            await handler.process()
            await asyncio.sleep(0.1)

if __name__ == '__main__':
    asyncio.run(main())

