from asyncua import Client
import asyncio
import socket
ENDPOINT = 'opc.tcp://2.2.2.7:53530/OPCUA/SimulationServer'
NAMESPACE = 'http://www.prosysopc.com/OPCUA/SimulationServer/'

msgFromClient = "Hello UDP Server"
bytesToSend = str.encode(msgFromClient)
serverAddressPort = ("2.2.2.5", 20002)
bufferSize = 1024
UDPClientSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)

async def get_send_hash():
    async with Client(url=ENDPOINT) as client:
        root = client.get_root_node()
        root_objects = await root.get_children()
        nm_no = await client.get_namespace_index("http://www.prosysopc.com/OPCUA/SimulationNodes/")
        while True:
            main_obj = []
            Objects = await root_objects[0].get_children()
            for sub_obj in Objects:
                if (sub_obj.nodeid.NamespaceIndex == nm_no):
                    ch = await sub_obj.get_children()
                    main_obj = main_obj + ch
            UDPClientSocket.sendto(str.encode(str(hash(str(main_obj)))), serverAddressPort)
            print(hash(str(main_obj)))

if __name__ == '__main__':
    asyncio.run(get_send_hash())