from asyncua import Client
import asyncio
import socket
from time import sleep
import pickle
ENDPOINT = 'opc.tcp://2.2.2.7:53530/OPCUA/SimulationServer'
NAMESPACE = 'http://www.prosysopc.com/OPCUA/SimulationServer/'

msgFromClient = "Hello UDP Server"
bytesToSend = str.encode(msgFromClient)
serverAddressPort = ("2.2.2.5", 20002)
bufferSize = 1024
UDPClientSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)

async def get_send_hash():
    async with Client(url=ENDPOINT) as client:
        root = client.get_root_node()
        root_objects = await root.get_children()
        nm_no = await client.get_namespace_index("http://www.prosysopc.com/OPCUA/SimulationNodes/")
        while True:
            sleep(1)
            individual_node={}
            hierarchy = {}
            Objects = await root_objects[0].get_children()
            for sub_obj in Objects:
                if (sub_obj.nodeid.NamespaceIndex == nm_no):
                    display_name=await sub_obj.read_display_name()
                    identifier_type = sub_obj.nodeid.NodeIdType._name_
                    children = await sub_obj.get_children()
                    for ch in children:
                        identifier= ch.nodeid.Identifier
                        individual_node[identifier]={}
                        node_name=await ch.read_display_name()
                        individual_node[identifier]["node_name"] =node_name.Text
                        datatype=await ch.read_data_type_as_variant_type()
                        individual_node[identifier]["datatype"] = datatype._value_
                    hierarchy[display_name.Text] = {}
                    hierarchy[display_name.Text]["name"]=identifier_type
                    hierarchy[display_name.Text]["obj"]=pickle.dumps(individual_node)
            hierarchy["hash"]=hash(str(hierarchy))
            hierarchy=pickle.dumps(hierarchy)
            UDPClientSocket.sendto(hierarchy, serverAddressPort)
            #print(hierarchy)

def send_hash():
    asyncio.run(get_send_hash())