import tkinter as tk
from opcua_transmitter import transmitter_main
from opcua_receiver import receive_main

class App(tk.Frame):
    def __init__(self, master=None):
        super().__init__(master)
        self.master = master
        self.pack()
        self.create_widgets()

    def create_widgets(self):
        # Label at the top
        self.label = tk.Label(self, text="Choose the right operation:")
        self.label.pack(side="top")

        # Send button
        self.send_button = tk.Button(self, text="Send", command=self.send_window)
        self.send_button.pack(side="left")

        # Receive button
        self.receive_button = tk.Button(self, text="Receive", command=self.receive_window)
        self.receive_button.pack(side="right")

    def send_window(self):
        # Remove existing widgets
        self.label.pack_forget()
        self.send_button.pack_forget()
        self.receive_button.pack_forget()

        # URL label and entry widget
        self.url_label = tk.Label(self, text="Enter Endpoint URL:")
        self.url_label.pack(side="top")
        self.url_entry = tk.Entry(self)
        self.url_entry.pack(side="top")

        self.namespace_label = tk.Label(self, text="Enter Namespace URL:")
        self.namespace_label.pack(side="top")
        self.namespace_entry = tk.Entry(self)
        self.namespace_entry.pack(side="top")

        self.server_hash_udp_ip_label = tk.Label(self, text="Enter server_hash_udp_ip:")
        self.server_hash_udp_ip_label.pack(side="top")
        self.server_hash_udp_ip_entry = tk.Entry(self)
        self.server_hash_udp_ip_entry.pack(side="top")

        self.server_hash_udp_port_label = tk.Label(self, text="Enter server_hash_port_ip:")
        self.server_hash_udp_port_label.pack(side="top")
        self.server_hash_udp_port_entry = tk.Entry(self)
        self.server_hash_udp_port_entry.pack(side="top")

        self.server_udp_ip_label = tk.Label(self, text="Enter server_udp_ip:")
        self.server_udp_ip_label.pack(side="top")
        self.server_udp_ip_entry = tk.Entry(self)
        self.server_udp_ip_entry.pack(side="top")

        self.server_udp_port_label = tk.Label(self, text="Enter server_port_ip:")
        self.server_udp_port_label.pack(side="top")
        self.server_udp_port_entry = tk.Entry(self)
        self.server_udp_port_entry.pack(side="top")

        # Submit button
        self.submit_button = tk.Button(self, text="Submit", command=lambda: self.submit_url("Send"))
        self.submit_button.pack(side="top")

        # Back button
        self.back_button = tk.Button(self, text="Back", command=self.back_of_send)
        self.back_button.pack(side="top")

    def receive_window(self):
        # Remove existing widgets
        self.label.pack_forget()
        self.send_button.pack_forget()
        self.receive_button.pack_forget()

        # URL label and entry widget
        self.url_label = tk.Label(self, text="Enter URL:")
        self.url_label.pack(side="top")
        self.url_entry = tk.Entry(self)
        self.url_entry.pack(side="top")

        self.namespace_label = tk.Label(self, text="Enter Namespace URL:")
        self.namespace_label.pack(side="top")
        self.namespace_entry = tk.Entry(self)
        self.namespace_entry.pack(side="top")

        self.udp_hash_receiver_ip_label = tk.Label(self, text="Enter udp_hash_receiver_ip:")
        self.udp_hash_receiver_ip_label.pack(side="top")
        self.udp_hash_receiver_ip_entry = tk.Entry(self)
        self.udp_hash_receiver_ip_entry.pack(side="top")

        self.udp_hash_receiver_port_label = tk.Label(self, text="Enter udp_hash_receiver_port:")
        self.udp_hash_receiver_port_label.pack(side="top")
        self.udp_hash_receiver_port_entry = tk.Entry(self)
        self.udp_hash_receiver_port_entry.pack(side="top")

        self.udp_ip_label = tk.Label(self, text="Enter udp_ip:")
        self.udp_ip_label.pack(side="top")
        self.udp_ip_entry = tk.Entry(self)
        self.udp_ip_entry.pack(side="top")

        self.udp_port_label = tk.Label(self, text="Enter server_port:")
        self.udp_port_label.pack(side="top")
        self.udp_port_entry = tk.Entry(self)
        self.udp_port_entry.pack(side="top")

        # Submit button
        self.submit_button = tk.Button(self, text="Submit", command=lambda: self.submit_url("Receive"))
        self.submit_button.pack(side="top")

        # Back button
        self.back_button = tk.Button(self, text="Back", command=self.back_of_receive)
        self.back_button.pack(side="top")

    def submit_url(self, button_label):
        # Get the URL from the entry widget

        # Do something with the URL (e.g. send or receive data)

        if(button_label=="Send"):
            url = self.url_entry.get()
            namespace = self.namespace_entry.get()
            hash_server_ip = self.server_hash_udp_ip_entry.get()
            hash_server_port = int(self.server_hash_udp_port_entry.get())
            send_to_ip = self.server_udp_ip_entry.get()
            send_to_port = int(self.server_udp_port_entry.get())
            status = transmitter_main(hash_server_ip,hash_server_port,send_to_ip,send_to_port,url,namespace)
        else:
            Endpoint_Url = self.url_entry.get()
            Namespace_Server = self.namespace_entry.get()
            udp_hash_receiver_ip = self.udp_hash_receiver_ip_entry.get()
            udp_hash_receiver_port = self.udp_hash_receiver_port_entry.get()
            localIP = self.udp_ip_entry.get()
            localPort = self.udp_port_entry.get()
            status = receive_main(Endpoint_Url,Namespace_Server,udp_hash_receiver_ip,udp_hash_receiver_port,localIP,localPort)

    def back_of_send(self):
        # Remove existing widgets
        self.url_label.pack_forget()
        self.url_entry.pack_forget()
        self.submit_button.pack_forget()
        self.back_button.pack_forget()
        self.namespace_label.pack_forget()
        self.namespace_entry.pack_forget()
        self.server_hash_udp_ip_entry.pack_forget()
        self.server_hash_udp_ip_label.pack_forget()
        self.server_hash_udp_port_entry.pack_forget()
        self.server_hash_udp_port_label.pack_forget()
        self.server_udp_ip_entry.pack_forget()
        self.server_udp_ip_label.pack_forget()
        self.server_udp_port_entry.pack_forget()
        self.server_udp_port_label.pack_forget()

    def back_of_receive(self):
        self.url_label.pack_forget()
        self.url_entry.pack_forget()
        self.submit_button.pack_forget()
        self.back_button.pack_forget()
        self.namespace_label.pack_forget()
        self.namespace_entry.pack_forget()
        self.udp_hash_receiver_ip_entry.pack_forget()
        self.udp_hash_receiver_ip_label.pack_forget()
        self.udp_hash_receiver_port_entry.pack_forget()
        self.udp_hash_receiver_port_label.pack_forget()
        self.udp_ip_label.pack_forget()
        self.udp_port_label.pack_forget()
        self.udp_ip_entry.pack_forget()
        self.udp_port_entry.pack_forget()

        self.create_widgets()

# Create the main window
root = tk.Tk()

# Create the app
app = App(master=root)

# Run the app
app.mainloop()
