import asyncio
import pickle
from asyncua import ua, Server
import socket
import threading
from time import sleep
import json

localIP = "2.2.2.5"
localPort = 20002
bufferSize = 1024
UDPServerSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)
UDPServerSocket.bind((localIP, localPort))

class asyncua_server():
    def __init__(self):
        self.server=None
        self.idx=None

    async def delete_nodes(self,nodes):
        for node in nodes:
            node = "ns=3;i=" + node if node.isdigit() else "ns=3;s=" + node
            node = self.server.get_node(node)
            await self.server.delete_nodes([node])

    async def start_server(self,url,uri):
        # create a server
        self.server = Server()
        await self.server.init()
        # set endpoint information
        url = url
        self.server.set_endpoint(url)
        # create a new address space
        uri = uri
        self.idx = await self.server.register_namespace(uri)
        await self.server.start()
        try:
            # keep the server running until interrupted
            while True:
                #var.write_value(random.randint(1, 100))
                await asyncio.sleep(0.1)
        finally:
            # stop the server
            await self.server.stop()

    async def add_object(self,node, parent_node, hierarchy):
        if (parent_node == None):
            if (node.isdigit()):
                node_index = "ns=3;i=" + node
            else:
                node_index = "ns=3;s=" + node
            await self.server.nodes.objects.add_folder(node_index, hierarchy["name"])
        else:
            if (parent_node.isdigit()):
                node_index = "ns=3;i=" + parent_node
            else:
                node_index = "ns=3;s=" + parent_node
            node_space = self.server.get_node(node_index)
            node_id="ns=3;i="+node if node.isdigit() else "ns=3;s="+node
            if(hierarchy["type"]==1):
                await node_space.add_object(node_id,hierarchy["name"])
            elif(hierarchy["type"]==2):
                print(hierarchy["datatype"])
                if(hierarchy["datatype"]==11):
                    var = await node_space.add_variable(node_id,hierarchy["name"],float(0.0))
                    await var.set_writable()
                elif(hierarchy["datatype"]==6):
                    var = await node_space.add_variable(node_id, hierarchy["name"], 0,ua.VariantType.Int32)
                    await var.set_writable()
                elif (hierarchy["datatype"] == 24):
                    var = await node_space.add_variable(node_id, hierarchy["name"], 0, ua.VariantType.Null)
                    await var.set_writable()
                else:
                    var = await node_space.add_variable(node_id, hierarchy["name"], None)
                    await var.set_writable()

asr = asyncua_server()
identifier_array_received=[]
identifier_array_existing=[]

def get_received_hierarchy_array(hierarchy):
    for key in hierarchy:
        if(key!="hash"):
            if(isinstance(hierarchy[key],dict)):
                identifier_array_received.append(key)
                get_received_hierarchy_array(hierarchy[key])
    return identifier_array_received

async def get_existing_hierarchy_array(client,node_objects):
    node_hierarchy = {}
    for sub_obj in node_objects:
        if ("ns=3;" in str(sub_obj)):
            node = client.get_node(sub_obj)
            children_nodes = await node.get_children()
            identifier = str(children_nodes[0].nodeid.Identifier) if children_nodes else ""
            if (identifier not in str(sub_obj)):
                identifier_name = sub_obj.nodeid.Identifier
                identifier_array_existing.append(str(identifier_name))
                node_hierarchy[identifier_name] = await get_existing_hierarchy_array(client, children_nodes)
            else:
                identifier_name = sub_obj.nodeid.Identifier
                identifier_array_existing.append(str(identifier_name))
    return identifier_array_existing



def add_nodes(nodes_to_add,hierarchy,parent_key=None):
    for key in hierarchy:
        if (key != "hash"):
            if (isinstance(hierarchy[key], dict)):
                if (key in nodes_to_add):
                    asyncio.run(asr.add_object(key, parent_key,hierarchy[key]))
                add_nodes(nodes_to_add,hierarchy[key],key)

def analyse_hierarchy(hierarchy):
    array1=get_received_hierarchy_array(hierarchy)
    root_node=asr.server.get_root_node()
    object_root_node=asyncio.run(root_node.get_children())
    node_objects= asyncio.run(object_root_node[0].get_children())
    array2=asyncio.run(get_existing_hierarchy_array(asr.server,node_objects))
    nodes_to_add=set(array1)-set(array2)
    nodes_to_delete=set(array2)-set(array1)
    add_nodes(nodes_to_add,hierarchy)
    asyncio.run(asr.delete_nodes(nodes_to_delete))
    identifier_array_received.clear()
    identifier_array_existing.clear()

def hash_receive():
    prev_hash = 0
    sleep(1)
    while (True):
        bytesAddressPair = UDPServerSocket.recvfrom(bufferSize)
        message = bytesAddressPair[0]
        hierarchy=pickle.loads(message)
        hierarchy=json.loads(hierarchy)
        if(prev_hash!=hierarchy["hash"] and asr.idx):
            analyse_hierarchy(hierarchy)
            prev_hash=hierarchy["hash"]

def st():
    t1=threading.Thread(target=hash_receive)
    t1.start()
    asyncio.run(asr.start_server("opc.tcp://2.2.2.5:53531/myopc/free","http://klopc.com"))