import asyncio
import pickle
from asyncua import ua, Server
import socket
import threading
from time import sleep
import json

localIP = "2.2.2.5"
localPort = 20002
bufferSize = 1024
UDPServerSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)
UDPServerSocket.bind((localIP, localPort))

class asyncua_server():
    def __init__(self):
        self.server=None
        self.idx=None

    async def delete_all_objects(self):
        root_nodes=await self.server.get_root_node().get_children()
        obj_nodes=await root_nodes[0].get_children()
        for node in obj_nodes:
            if("ns=" in str(node)):
                print(node)
                sub_obj = await self.server.get_node(node).get_children()
                for del_node in sub_obj:
                    await self.server.delete_nodes([del_node])
                await self.server.delete_nodes([node])

    async def add_object(self,obj,hierarchy):
        if(hierarchy[obj]["name"]=="String"):
            var_obj= await self.server.nodes.objects.add_folder(self.idx,obj )
            val_array=pickle.loads(hierarchy[obj]["obj"])
            for identifier in val_array:
                if(val_array[identifier]["datatype"]==11):
                   var = await var_obj.add_variable(ua.NodeId(identifier,3),val_array[identifier]["node_name"], float(0.0))#ua.NodeId(ua.ObjectIds.Double))
                   await var.set_writable()
                if (val_array[identifier]["datatype"] == 6):
                   var = await var_obj.add_variable(ua.NodeId(identifier,3), val_array[identifier]["node_name"], 0,ua.VariantType.Int32)#ua.NodeId(ua.ObjectIds.Int32))
                   await var.set_writable()
        else:
            await self.server.nodes.objects.add_folder(self.idx, obj)

    async def add_variable(self,obj,var):
        var = await obj.add_variable(self.idx,var, 11)
        await var.set_writable()
        return var

    async def start_server(self,url,uri):
        # create a server
        self.server = Server()
        await self.server.init()
        # set endpoint information
        url = url
        self.server.set_endpoint(url)
        # create a new address space
        uri = uri
        self.idx = await self.server.register_namespace(uri)
        await self.server.start()
        try:
            # keep the server running until interrupted
            while True:
                #var.write_value(random.randint(1, 100))
                await asyncio.sleep(0.1)
        finally:
            # stop the server
            await self.server.stop()

asr = asyncua_server()
identifier_array_received=[]
def get_received_hierarchy_array(hierarchy):
    for key in hierarchy:
        if(key!="hash"):
            if(isinstance(hierarchy[key],dict)):
                identifier_array_received.append(key)
                get_received_hierarchy_array(hierarchy[key])
    return identifier_array_received

async def get_existing_hierarchy_array(client,node_objects):
    node_hierarchy = {}
    for sub_obj in node_objects:
        if ("ns=3;" in str(sub_obj)):
            node = client.get_node(sub_obj)
            children_nodes = await node.get_children()
            identifier = str(children_nodes[0].nodeid.Identifier) if children_nodes else ""
            node_class = await sub_obj.read_node_class()
            if (identifier not in str(sub_obj)):
                child_disp_name = await sub_obj.read_display_name()
                identifier_name = sub_obj.nodeid.Identifier
                node_hierarchy[identifier_name] = await get_existing_hierarchy_array(client, children_nodes)
                node_hierarchy[identifier_name]["name"] = child_disp_name.Text
                if (node_class._name_ == "Variable"):
                    datatype = await sub_obj.read_data_type_as_variant_type()
                    node_hierarchy[identifier_name]["datatype"] = datatype._value_
            else:
                disp_name = await sub_obj.read_display_name()
                identifier_name = sub_obj.nodeid.Identifier
                node_hierarchy[identifier_name] = {}
                node_hierarchy[identifier_name]["name"] = disp_name.Text
                if (node_class._name_ == "Variable"):
                    datatype = await sub_obj.read_data_type_as_variant_type()
                    node_hierarchy[identifier_name]["datatype"] = datatype._value_
    return node_hierarchy

def analyse_hierarchy(hierarchy):
    array1=get_received_hierarchy_array(hierarchy)
    print(array1)
    root_node=asr.server.get_root_node()
    object_root_node=asyncio.run(root_node.get_children())
    node_objects= asyncio.run(object_root_node[0].get_children())
    print(node_objects)
    existing_h=asyncio.run(get_existing_hierarchy_array(asr.server,node_objects))
    print(existing_h)
    identifier_array_received.clear()

def hash_receive():
    prev_hash = 0
    sleep(1)
    while (True):
        bytesAddressPair = UDPServerSocket.recvfrom(bufferSize)
        message = bytesAddressPair[0]
        hierarchy=pickle.loads(message)
        hierarchy=json.loads(hierarchy)
        if(prev_hash!=hierarchy["hash"] and asr.idx):
            print("changed")
            analyse_hierarchy(hierarchy)
            asyncio.run(asr.delete_all_objects())
            for object in hierarchy:
                if(object!="hash"):
                    display_name=object
                    asyncio.run(asr.add_object(object,hierarchy))
            prev_hash=hierarchy["hash"]

def st():
    t1=threading.Thread(target=hash_receive)
    t1.start()
    asyncio.run(asr.start_server("opc.tcp://2.2.2.5:53531/myopc/free","http://klopc.com"))