import socket
from opcua import Client,ua
from opcua_subscriber.opcua_subscribe import *
from asyncua_server import asyncua_server

# client = Client("opc.tcp:2.2.2.7:53530/OPCUA/SimulationServer")
# client.connect()

localIP = "2.2.2.5"

localPort = 20001

bufferSize = 1024

msgFromServer = "Hello UDP Client"

bytesToSend = str.encode(msgFromServer)

# Create a datagram socket

UDPServerSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)

# Bind to address and ip

UDPServerSocket.bind((localIP, localPort))

print("UDP server up and listening")
opua=opcua_pack()
sock = opua.connect("opc.tcp://2.2.2.5:53530/OPCUA/SimulationServer")

as_server=asyncua_server()
as_server.start_server("opc.tcp://localhost:4840/myopc/free","http://klopc.com")
as_server.add_object("Myobj_")

while (True):
    bytesAddressPair = UDPServerSocket.recvfrom(bufferSize)
    message = bytesAddressPair[0]
    datatype,value,ns,nodeid = message.decode().split("&")
    print(nodeid)
    opua.write_opcua_value(sock,ns,nodeid, value,datatype)
