import asyncio
from asyncua import ua, Server
import random

class asyncua_server():
    def __init__(self):
        self.server=None
        self.idx=None

    async def add_object(self,obj):
         return await self.server.nodes.objects.add_object(self.idx,obj )

    async def add_variable(self,obj,var):
        var= await obj.add_variable(self.idx,var, 11)
        await var.set_writable()
        return var

    async def start_server(self,url,uri):
        # create a server
        self.server = Server()
        await self.server.init()
        # set endpoint information
        url = url
        self.server.set_endpoint(url)
        # create a new address space
        uri = uri
        self.idx = await self.server.register_namespace(uri)
        # obj = await self.add_object(self.idx,"MyObject")
        # var = await self.add_variable(obj,self.idx,"Myvar")

        # start the server
        await self.server.start()
        try:
            # keep the server running until interrupted
            while True:
                #await var.write_value(random.randint(1, 100))
                await asyncio.sleep(1)
        finally:
            # stop the server
            await self.server.stop()

if __name__ == "__main__":
    asua=asyncua_server()
    asyncio.run(asua.start_server())
