import asyncio
import pickle
from asyncua import ua, Server
import socket
import threading
from time import sleep

localIP = "2.2.2.5"
localPort = 20002
bufferSize = 1024
UDPServerSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)
UDPServerSocket.bind((localIP, localPort))

class asyncua_server():
    def __init__(self):
        self.server=None
        self.idx=None

    async def delete_all_objects(self):
        root_nodes=await self.server.get_root_node().get_children()
        obj_nodes=await root_nodes[0].get_children()
        for node in obj_nodes:
            if("ns=" in str(node) and "ns=2;i=1" not in str(node)):
                print(node)
                sub_obj = await self.server.get_node(node).get_children()
                for del_node in sub_obj:
                    await self.server.delete_nodes([del_node])
                await self.server.delete_nodes([node])

    async def add_object(self,obj,hierarchy):
        if(hierarchy[obj]["name"]=="String"):
            var_obj= await self.server.nodes.objects.add_folder(self.idx,obj )
            val_array=pickle.loads(hierarchy[obj]["obj"])
            for identifier in val_array:
                if(val_array[identifier]["datatype"]==11):
                   var = await var_obj.add_variable(ua.NodeId(identifier,3),val_array[identifier]["node_name"], float(0.0))#ua.NodeId(ua.ObjectIds.Double))
                   await var.set_writable()
                if (val_array[identifier]["datatype"] == 6):
                   var = await var_obj.add_variable(ua.NodeId(identifier,3), val_array[identifier]["node_name"], 0,ua.VariantType.Int32)#ua.NodeId(ua.ObjectIds.Int32))
                   await var.set_writable()
        else:
            await self.server.nodes.objects.add_folder(self.idx, obj)

    async def add_variable(self,obj,var):
        var = await obj.add_variable(self.idx,var, 11)
        await var.set_writable()
        return var

    async def start_server(self,url,uri):
        # create a server
        self.server = Server()
        await self.server.init()
        # set endpoint information
        url = url
        self.server.set_endpoint(url)
        root_nodes = await self.server.get_root_node().get_children()
        obj_nodes = await root_nodes[0].get_children()
        # create a new address space
        uri = uri
        self.idx = await self.server.register_namespace(uri)
        await self.server.start()
        try:
            # keep the server running until interrupted
            while True:
                #var.write_value(random.randint(1, 100))
                await asyncio.sleep(0.1)
        finally:
            # stop the server
            await self.server.stop()

asr = asyncua_server()

def hash_receive():
    prev_hash = 0
    sleep(1)
    while (True):
        bytesAddressPair = UDPServerSocket.recvfrom(bufferSize)
        message = bytesAddressPair[0]
        hierarchy=pickle.loads(message)
        if(prev_hash!=hierarchy["hash"] and asr.idx):
            asyncio.run(asr.delete_all_objects())
            for object in hierarchy:
                if(object!="hash"):
                    display_name=object
                    asyncio.run(asr.add_object(object,hierarchy))
            prev_hash=hierarchy["hash"]

def st():
    t1=threading.Thread(target=hash_receive)
    t1.start()
    asyncio.run(asr.start_server("opc.tcp://2.2.2.5:53531/myopc/free","http://klopc.com"))