import socket
from time import sleep
from opcua_subscriber.opcua_subscribe import opcua_pack
from asyncua_server import st
import threading
import yaml

yamlfile=open("opc_ua_transmitter_config.yaml")
data = yaml.load(yamlfile, Loader=yaml.FullLoader)
Endpoint_Url = data["configuration"]["endpoint_url"]
Namespace_Server = data["configuration"]["namespace_server"]
udp_hash_receiver_ip=data["configuration"]["udp_hash_receiver_ip"]
udp_hash_receiver_port=data["configuration"]["udp_hash_receiver_port"]
localIP = data["configuration"]["udp_ip"]
localPort = data["configuration"]["udp_port"]

bufferSize = 1024
UDPServerSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)
UDPServerSocket.bind((localIP, localPort))

print("UDP server up and listening")
t1=threading.Thread(target=st,args=(Endpoint_Url,Namespace_Server,udp_hash_receiver_ip,udp_hash_receiver_port,))
t1.start()
sleep(5)
opua=opcua_pack()
sock = opua.connect(Endpoint_Url)

while (True):
    bytesAddressPair = UDPServerSocket.recvfrom(bufferSize)
    message = bytesAddressPair[0]
    datatype,value,ns,nodeid = message.decode().split("&")
    opua.write_opcua_value(sock,ns,nodeid, value,datatype)