import asyncio
from asyncua import ua, Server
import random
import threading

class asyncua_server():
    def __init__(self):
        self.server=None
        self.idx=None

    async def add_object(self,obj):
        print(self.idx,obj)
        return await self.server.nodes.objects.add_object(self.idx,obj )

    async def add_variable(self,obj,var):
        var= await obj.add_variable(self.idx,var, 11)
        await var.set_writable()
        return var

    async def start_server(self,url,uri):
        print(url)
        # create a server
        self.server = Server()
        await self.server.init()
        # set endpoint information
        url = url
        self.server.set_endpoint(url)
        # create a new address space
        uri = uri
        self.idx = await self.server.register_namespace(uri)
        await self.server.start()
        obj = self.server.nodes.objects.add_object(self.idx, "MyObject")
        try:
            # keep the server running until interrupted
            while True:
                #var.write_value(random.randint(1, 100))
                await asyncio.sleep(0.1)
        finally:
            # stop the server
            await self.server.stop()



def st():
    asr = asyncua_server()
    asyncio.run(asr.start_server("opc.tcp://localhost:4840/myopc/free","http://klopc.com"))
