import socket
from opcua import Client,ua

client = Client("opc.tcp://DESKTOP-KMDNN6H:53530/OPCUA/SimulationServer")
client.connect()

localIP = "2.2.2.5"

localPort = 20001

bufferSize = 1024

msgFromServer = "Hello UDP Client"

bytesToSend = str.encode(msgFromServer)

# Create a datagram socket

UDPServerSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)

# Bind to address and ip

UDPServerSocket.bind((localIP, localPort))

print("UDP server up and listening")

while (True):
    bytesAddressPair = UDPServerSocket.recvfrom(bufferSize)
    message = bytesAddressPair[0]
    datatype,value,nodeid = message.decode().split("&")
    if(datatype=="<class 'float'>"):
        client.get_node(nodeid).set_value(float(value))
    if(datatype=="<class 'int'>"):
        v = ua.DataValue(ua.Variant(int(value), ua.VariantType.Int32))
        client.get_node(nodeid).set_value(v)