import socket
from opcua import Client,ua
from opcua_subscriber.opcua_subscribe import *
from asyncua_server import st
import asyncio
import threading

localIP = "2.2.2.5"

localPort = 20001

bufferSize = 1024

msgFromServer = "Hello UDP Client"

bytesToSend = str.encode(msgFromServer)

# Create a datagram socket

UDPServerSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)

# Bind to address and ip

UDPServerSocket.bind((localIP, localPort))

print("UDP server up and listening")
t1=threading.Thread(target=st,args=())
t1.start()
sleep(30)
print("here")
opua=opcua_pack()
sock = opua.connect("opc.tcp://2.2.2.5:53531/myopc/free")

while (True):
    bytesAddressPair = UDPServerSocket.recvfrom(bufferSize)
    message = bytesAddressPair[0]
    datatype,value,ns,nodeid = message.decode().split("&")
    if("int" in datatype):
        print(value)
    opua.write_opcua_value(sock,ns,nodeid, value,datatype)