import socket
from time import sleep
from opcua_subscriber.opcua_subscribe import opcua_pack
from asyncua_server import st
import threading
Endpoint_Url = "opc.tcp://2.2.2.5:53531/myopc/free"
Namespace_Server ="http://klopc.com"

udp_hash_receiver_ip="2.2.2.5"
udp_hash_receiver_port=20002


localIP = "2.2.2.5"
localPort = 20001
bufferSize = 1024
UDPServerSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)
UDPServerSocket.bind((localIP, localPort))

print("UDP server up and listening")
t1=threading.Thread(target=st,args=(Endpoint_Url,Namespace_Server,udp_hash_receiver_ip,udp_hash_receiver_port,))
t1.start()
sleep(5)
opua=opcua_pack()
sock = opua.connect(Endpoint_Url)

while (True):
    bytesAddressPair = UDPServerSocket.recvfrom(bufferSize)
    message = bytesAddressPair[0]
    datatype,value,ns,nodeid = message.decode().split("&")
    opua.write_opcua_value(sock,ns,nodeid, value,datatype)