import paramiko
import configparser
import json
import csv
import os
main_req = 1
len_c=0

f=open('rasbian_os.json')
config = configparser.ConfigParser()
config.read('config.conf')
data=json.load(f)

if(os.path.exists("Linux_Hardening_Report.csv")):
    os.remove("Linux_Hardening_Report.csv")
file=open('Linux_Hardening_Report.csv',"a", newline='')
read_file=csv.reader(file)
fieldnames = ['Standard','Input', 'Requirement', 'Remedition','Output']
write_file = csv.DictWriter(file, fieldnames=fieldnames)
write_file.writeheader()


def insert_to_csv(standard,input,requirement,remedition,output,main_req):
    para=""
    for i in remedition:
        para=para+"\n"+"Desc: "+i["desc"]+"\nCommand: "+i["command"]
    if(main_req):
        write_file.writerow({'Standard': standard ,'Input':input, 'Requirement': requirement, 'Remedition':para,'Output':output})
    else:
        write_file.writerow({'Standard': "", 'Input': input, 'Requirement': requirement, 'Remedition': para,'Output':output})
def alternative(out,command):
    if(command["output"]=="Weak Config"):
        flag=1
        for i in command["alternative"]:
            if(i["al_cm"] in out):
                flag=0
        return flag
    elif(command["output"]=="Script"):
        if(out==""):
            return 1
        else:
            return 0
    else:
        for i in command["alternative"]:
            if out == i["al_cm"]:
                return 1
            elif (i["al_cm"] == "any"):
                return 1
            else:
                return 0

def exist_line(out,command):
    if(command["exist_line"]):
        if(command["exist_line"] in out):
            return 1
        else:
            return 0

def manage_output(_stdin,out,err,command,values):
    global main_req
    if (err):
        if (command["can_have_error"] == "yes"):
            insert_to_csv(values["name"], command["input"], "Satisfied", "", err, main_req)
            main_req = 0
        else:
            insert_to_csv(values["name"], command["input"], "Not Satisfied", values["Remediation"],err, main_req)
            main_req = 0
    elif (out == command["output"] or alternative(out,command) or exist_line(out,command)):
        insert_to_csv(values["name"], command["input"], "Satisfied", "", out, main_req)
        main_req = 0
    else:
        insert_to_csv(values["name"], command["input"], "Not Satisfied", values["Remediation"], out,main_req)
        main_req = 0

def check(client):
    global main_req
    global len_c
    print("\nPLEASE WAIT WHILE THE SCAN IS COMPLETE :)\n")
    for values in data:
        main_req = 1
        len_c=len_c+1
        os.system('cls')
        print('\r...........IN PROGRESS......('+str(int((len_c/len(data))*100))+')%', end='')
        for command in values["cmd"]:
            split_cmd=command["input"].split()
            sbin=client.exec_command("ls /usr/sbin/")[1].read().decode()
            sbin=sbin.split()
            insbin=0
            for line in sbin:
                if(line==split_cmd[0]):
                    insbin=1
            if(command["output"]=="Script"):
                _stdin, _stdout, _stderr = client.exec_command("echo '"+command["input"]+"' > program.sh")
                _stdin, _stdout, _stderr = client.exec_command("sudo sh program.sh")
                err = _stderr.read().decode()
                out = _stdout.read().decode()
                manage_output(_stdin, out, err, command, values)
            elif (insbin):
                _stdin, _stdout, _stderr = client.exec_command("/usr/sbin/" + command["input"])
                err = _stderr.read().decode()
                out = _stdout.read().decode()
                manage_output(_stdin, out, err, command, values)
            else:
                _stdin, _stdout, _stderr = client.exec_command(command["input"])
                err = _stderr.read().decode()
                out = _stdout.read().decode()
                manage_output(_stdin, out, err, command, values)
    print("SCAN COMPLETE!!!!")


def connect():
    client = paramiko.client.SSHClient()
    client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
    client.connect(config.get('UTIL', 'host'),config.get('UTIL', 'port'), username=config.get('UTIL', 'username'), password=config.get('UTIL', 'password'))
    check(client)
    client.close()
    f.close()
    file.close()


if __name__ == '__main__':
    connect()

