import json
import yaml
import requests

try:
    yamlfile=open("config.yaml")
    data = yaml.load(yamlfile, Loader=yaml.FullLoader)
    transmit_assets=data["configuration"]["transmit_assets"]
    url = data["configuration"]["unifytwin_server_ip_address"]
except Exception as e:
    transmit_assets=False

try:
    with open("assets.json") as json_file:
        json_decoded = json.load(json_file)
except:
    json_decoded={}

def write_into_json_file(json_decoded):
    with open("assets.json", 'w') as json_file:
        json.dump(json_decoded, json_file)

def insert_asset(ip,last_activity,dev_type,protocols,mac,vendor,firmware,model,os,plant):
    json_decoded[ip]={}
    json_transmit_data={}
    json_transmit_data[ip]={}
    json_transmit_data[ip]["last_activity"]=json_decoded[ip]["last_activity"]=last_activity
    json_transmit_data[ip]["dev_type"]=json_decoded[ip]["dev_type"] =dev_type
    json_transmit_data[ip]["protocols"]=json_decoded[ip]["protocols"] = protocols
    json_transmit_data[ip]["mac"]=json_decoded[ip]["mac"] = mac
    json_transmit_data[ip]["vendor"]=json_decoded[ip]["vendor"] = vendor
    json_transmit_data[ip]["firmware"]=json_decoded[ip]["firmware"] = firmware
    json_transmit_data[ip]["model"]=json_decoded[ip]["model"] = model
    json_transmit_data[ip]["os"]=json_decoded[ip]["os"] = os
    json_transmit_data[ip]["plant"]=json_decoded[ip]["plant"] = plant
    write_into_json_file(json_decoded)
    if transmit_assets:
        requests.post(url=url,json=json_transmit_data)

def  update_asset(ip,prev_protocols,last_activity,dev_type,vendor,firmware,model):
    json_transmit_data = {}
    json_transmit_data[ip] = {}
    json_transmit_data[ip]["protocols"]=json_decoded[ip]["protocols"] = prev_protocols
    json_transmit_data[ip]["last_activity"]=json_decoded[ip]["last_activity"] = last_activity
    json_transmit_data[ip]["dev_type"]=json_decoded[ip]["dev_type"] = dev_type
    json_transmit_data[ip]["vendor"]=json_decoded[ip]["vendor"] = vendor
    json_transmit_data[ip]["firmware"]=json_decoded[ip]["firmware"] = firmware
    json_transmit_data[ip]["model"]=json_decoded[ip]["model"] = model
    write_into_json_file(json_decoded)
    if transmit_assets:
        requests.post(url=url, json=json_transmit_data)

def update_last_activity_and_protocols(ip,prev_protocols,last_activity):
    json_transmit_data = {}
    json_transmit_data[ip] = {}
    json_transmit_data[ip]["protocols"]=json_decoded[ip]["protocols"] = prev_protocols
    json_transmit_data[ip]["last_activity"]=json_decoded[ip]["last_activity"] = last_activity
    write_into_json_file(json_decoded)
    if transmit_assets:
        requests.post(url=url, json=json_transmit_data)

def update_last_activity(ip,last_activity):
    json_transmit_data = {}
    json_transmit_data[ip] = {}
    json_transmit_data[ip]["last_activity"]=json_decoded[ip]["last_activity"] = last_activity
    write_into_json_file(json_decoded)
    if transmit_assets:
        requests.post(url=url, json=json_transmit_data)

def delete_asset():
    print()

def get_existing_protocols(ip):
    try:
        return json_decoded[ip]["protocols"]
    except KeyError:
        return "No key"

def check_asset_exists(ip):
    if(ip in json_decoded):
        return True
    else:
        return False