import sqlite3
import threading
import requests
import yaml
import os
import json
from time import sleep
from sys import platform

yamlfile=open("config.yaml")
data = yaml.load(yamlfile, Loader=yaml.FullLoader)
plant=data["configuration"]["edge_device_location"]
lock = threading.Lock()
server_ip_address=data["configuration"]["unifytwin_server_ip_address"]

def transmit_all_assets():
    dicc={}
    retry=0
    try:
        if platform == "linux" or platform == "linux2":
            os.system(
                'sqlite3 cloned.db "DROP TABLE IF EXISTS inventory" |sqlite3 assets.db ".dump inventory"|sqlite3 cloned.db')
        elif platform == "darwin":
            os.system(
                'sqlite3 cloned.db "DROP TABLE IF EXISTS inventory" |sqlite3 assets.db ".dump inventory"|sqlite3 cloned.db')
        elif platform == "win32":
            os.system('del cloned.db && copy assets.db cloned.db')
        mydb=sqlite3.connect("cloned.db",check_same_thread=False)
        query=mydb.cursor()
        lock.acquire()
        lock.release()
        get_asset='SELECT * FROM inventory;'
        asset_list=query.execute(get_asset).fetchall()
        query.close()
        mydb.commit()
        mydb.close()
        #requests.get(server_ip_address, data=str(asset_list))
        for i in asset_list:
            dicc[i[0]]={}
            dicc[i[0]]["name"]=i[1]
            dicc[i[0]]["last_activity"]=i[2]
            dicc[i[0]]["type"]=i[3]
            dicc[i[0]]["protocols"]=i[4]
            dicc[i[0]]["mac_address"]=i[5]
            dicc[i[0]]["vendor"]=i[6]
            dicc[i[0]]["firmware_version"]=i[7]
            dicc[i[0]]["model"]=i[8]
            dicc[i[0]]["operating system"]=i[9]
            dicc[i[0]]["plant"]=i[10]
        return json.dumps(dicc)
    except Exception as e:
        pass

def periodic_transmit_all_assets():
    while True:
        sleep(7)
        retry=0
        try:
            if platform == "linux" or platform == "linux2":
                os.system('sqlite3 cloned.db "DROP TABLE IF EXISTS inventory" |sqlite3 assets.db ".dump inventory"|sqlite3 cloned.db')
            elif platform == "darwin":
                os.system('sqlite3 cloned.db "DROP TABLE IF EXISTS inventory" |sqlite3 assets.db ".dump inventory"|sqlite3 cloned.db')
            elif platform == "win32":
                os.system('del cloned.db && copy assets.db cloned.db')
            mydb=sqlite3.connect("cloned.db",check_same_thread=False)
            query=mydb.cursor()
            lock.acquire()
            lock.release()
            get_asset='SELECT * FROM inventory;'
            asset_list=query.execute(get_asset).fetchall()
            query.close()
            mydb.commit()
            mydb.close()
            requests.get(server_ip_address, data=str(asset_list))
        except Exception as e:
            print(e)
            retry=retry+1
            if(retry<3):
                periodic_transmit_all_assets()
            else:
                requests.get(server_ip_address, data=str(e))

def delete_all_assets():
    try:
        mydb = sqlite3.connect("assets.db", check_same_thread=False)
        query = mydb.cursor()
        statement='DELETE FROM inventory;'
        lock.acquire()
        lock.release()
        query.execute(statement)
        query.close()
        mydb.commit()
        mydb.close()
    except:
        delete_all_assets()
    return
