from sniff import start_sniff
import sys
import getopt
from utilities import list_interfaces as li
import asset_actions

global k_
k_ = {
    'start': None,
    'iface': None
}
def help(_exit_=False):
	print("Usage: %s [OPTION]\n" % sys.argv[0])
	print("\t--start\tStart sniff")
	print("\t-i\tSelect Interface")
	print("\t--list_interfaces\tSelect Interface")
	print("\t--transmit_assets\tTransmit all assets to Configured Server")
	if _exit_:
		sys.exit()


def main():
	global k_
	if len(sys.argv) < 2:
		help(1)
	try:
		opts, args = getopt.getopt(sys.argv[1:],"s:i:l:t:h:",["start","iface=","list_interfaces","transmit_assets","help"])
	except Exception as e:
		print(e)
	for o, a in opts:
		if o == '--start':
			k_['start'] = 1
		if o == '-i':
			k_['iface'] = a
		if o == '--list_interfaces':
			li.show_list()
		if o == '--transmit_assets':
			asset_actions.transmit_all_assets()
		if o == '--help':
			help(1)
	if(k_['start']):
		if(k_['iface']):
			start_sniff(k_['iface'])
		else:
			help(1)

if __name__ == '__main__':
	main()