import subprocess
import yaml

try:
    yamlfile = open("config.yaml")
    data = yaml.load(yamlfile, Loader=yaml.FullLoader)
    ui_host = data["configuration"]["ui_host"]
    ui_port = int(data["configuration"]["ui_port"])

except Exception as e:
    ui_host = "127.0.0.1"
    ui_port = 8080


def run_django_server(host, port):
    command = f"py manage.py runserver {host}:{port}"
    try:
        subprocess.run(command, shell=True, check=True)
    except subprocess.CalledProcessError:
        print("Error: Dango server failed to start.")


if __name__ == "__main__":
    run_django_server(ui_host, ui_port)