import socket
import struct
import json

def send_request(host, port):
    # Create the initial request packet
    req_info = bytes.fromhex("cc01000b4002000047ee")

    # Create a socket
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)

    try:
        # Connect to the host and port
        sock.connect((host, port))

        # Send the request
        sock.sendall(req_info)

        # Receive the response
        response = sock.recv(1024)  # Adjust the buffer size as needed

        # Check if the response is valid
        if response and response[0] == 0xcc:
            return response

    except Exception as e:
        print(f"Error: {e}")

    finally:
        sock.close()

    return None

def parse_response(response):
    output = {}

    # Extract data from the response using struct.unpack
    runtime = response[12:43]
    plc_type = response[43:72]
    project_name = response[76:88]
    boot_project = response[88:100]
    project_source_code = response[100:106]

    output["Ladder Logic Runtime"] = runtime.decode('utf-8').strip("\x00")
    output["PLC Type"] = plc_type.decode('utf-8').strip("\x00")
    output["Project Name"] = project_name.decode('utf-8').strip("\x00")
    output["Boot Project"] = boot_project.decode('utf-8').strip("\x00")
    output["Project Source Code"] = project_source_code.decode('utf-8').strip("\x00")

    return output

def action(host, port):
    response = send_request(host, port)
    if response:
        result = parse_response(response)
        return result


def get_info(ip,port):
  return(action(ip,port))