import smtplib
from email.mime.multipart import MIMEMultipart


class SendEmail:
    @staticmethod
    def send_file(sender_email, receiver, sender_password):
        try:
            with smtplib.SMTP('smtp.gmail.com', 587) as smtp:
                msg = MIMEMultipart()
                msg['From'] = sender_email
                msg['To'] = receiver
                msg['Subject'] = "weather report"
                smtp.starttls()

            with open("Weather Report_daily.xlsx", "rb") as file:
                file_data = file.read()
                file_name = file.name
                msg.add_attachment(file_data, maintype="weather", subtype="xlsx", filename=file_name)
            smtp.login(sender_email, sender_password)
            smtp.send_message(msg)
        except ValueError:
            raise ValueError
        except Exception as e:
            print(e, "Excel Error Detected")