import smtplib
import ssl
from email.message import EmailMessage
from email.mime.multipart import MIMEMultipart


class SendEmail:
    @staticmethod
    def send_file(sender_email, receiver, sender_password):
        try:
            files = ['Weather Report_daily.xlsx','Weather Report_weekly.xlsx','Weather Report_monthly.xlsx']
            msg = EmailMessage()
            msg['From'] = sender_email
            msg['To'] = receiver
            msg['Subject'] = "weather report"
            context = ssl.create_default_context()

            for file_read in files:
                with open(file_read, "rb") as file:
                    file_data = file.read()
                    file_name = file.name
                    print(file_name)
                    msg.add_attachment(file_data, maintype="application", subtype="xlsx", filename=file_name)
            with smtplib.SMTP_SSL('smtp.gmail.com', 465, context=context) as smtp:
                smtp.login(sender_email, sender_password)
                smtp.sendmail(sender_email, receiver, msg.as_string())
        except ValueError:
            raise ValueError
        except Exception as e:
            print(e, "Excel Error Detected")