import pandas as pd
import openpyxl


class WeatherDataReport:

    @staticmethod
    def daily_report(df, date):
        try:
            df[['Date', 'Time']] = df['Formatted Date'].str.split(' ', n=1, expand=True)
            filtered_df = df[df['Date'] == date]
            data_response = WeatherDataReport.get_data(filtered_df)
            new_response = {"date": date, "report": data_response}
            condition = "daily"
            WeatherDataReport.get_excel(data_response, condition)
            return new_response
        except ValueError:
            raise ValueError
        except Exception as e:
            print(e, "Error Detected")

    @staticmethod
    def weekly_report(df, start_date, end_date):
        try:
            df[["date", "time"]] = df["Formatted Date"].str.split(" ", n=1, expand=True)
            df["date"] = pd.to_datetime(df["date"])
            start_date = pd.to_datetime(start_date)
            end_date = pd.to_datetime(end_date)
            filtered_df = df.loc[(df["date"] >= start_date) & (df["date"] <= end_date)]
            data_response = WeatherDataReport.get_data(filtered_df)
            new_response = {"start date": start_date, "end date": end_date, "data": data_response}
            condition = "weekly"
            WeatherDataReport.get_excel(data_response, condition)
            return new_response
        except ValueError:
            raise ValueError
        except Exception as e:
            print(e, "Error Detected")

    @staticmethod
    def monthly_report(df, year, month):
        try:
            df[["date", "time"]] = df["Formatted Date"].str.split(" ", n=1, expand=True)
            df["date"] = pd.to_datetime(df["date"])
            df["date"] = pd.to_datetime(df["date"])
            filtered_df = df.loc[(df["date"].dt.year == year) & (df["date"].dt.month == month)]
            filtered_df = filtered_df.drop(columns=["time"])
            data_response = WeatherDataReport.get_data(filtered_df)
            new_response = {"year": year, "month": month, "data": data_response}
            condition = "monthly"
            WeatherDataReport.get_excel(data_response, condition)
            return new_response
        except ValueError:
            raise ValueError
        except Exception as e:
            print(e, "Error Detected")

    @staticmethod
    def get_data(filtered_df):
        avg_temp = round(filtered_df['Temperature (C)'].mean(axis=0), 2)
        min_temp = round(filtered_df['Temperature (C)'].min(axis=0), 2)
        max_temp = round(filtered_df['Temperature (C)'].max(axis=0), 2)

        # Apparent Temperature
        avg_at = round(filtered_df['Apparent Temperature (C)'].mean(axis=0), 2)
        min_at = round(filtered_df['Apparent Temperature (C)'].min(axis=0), 2)
        max_at = round(filtered_df['Apparent Temperature (C)'].max(axis=0), 2)

        # Humidity
        avg_hum = round(filtered_df['Humidity'].mean(axis=0), 2)
        min_hum = round(filtered_df['Humidity'].min(axis=0), 2)
        max_hum = round(filtered_df['Humidity'].max(axis=0), 2)

        # Wind Speed
        avg_ws = round(filtered_df['Wind Speed (km/h)'].mean(axis=0), 2)
        min_ws = round(filtered_df['Wind Speed (km/h)'].min(axis=0), 2)
        max_ws = round(filtered_df['Wind Speed (km/h)'].max(axis=0), 2)

        # Wind Bearing
        avg_wb = round(filtered_df['Wind Bearing (degrees)'].mean(axis=0), 2)
        min_wb = round(filtered_df['Wind Bearing (degrees)'].min(axis=0), 2)
        max_wb = round(filtered_df['Wind Bearing (degrees)'].max(axis=0), 2)

        # Visibility
        avg_vis = round(filtered_df['Visibility (km)'].mean(axis=0), 2)
        min_vis = round(filtered_df['Visibility (km)'].min(axis=0), 2)
        max_vis = round(filtered_df['Visibility (km)'].max(axis=0), 2)

        # Pressure
        avg_pre = round(filtered_df['Pressure (millibars)'].mean(axis=0), 2)
        min_pre = round(filtered_df['Pressure (millibars)'].min(axis=0), 2)
        max_pre = round(filtered_df['Pressure (millibars)'].max(axis=0), 2)
        value_return = {
            "Average": {"Temperature": avg_temp, "Apparent Temperature": avg_at, "Humidity": avg_hum,
                        "Wind Speed": avg_ws, "Wind Bearing": avg_wb, "Visibility": avg_vis,
                        "Pressure": avg_pre},
            "Minimum": {"Temperature": min_temp, "Apparent Temperature": min_at, "Humidity": min_hum,
                        "Wind Speed": min_ws, "Wind Bearing": min_wb, "Visibility": min_vis,
                        "Pressure": min_pre},
            "Maximum": {"Temperature": max_temp, "Apparent Temperature": max_at, "Humidity": max_hum,
                        "Wind Speed": max_ws, "Wind Bearing": max_wb, "Visibility": max_vis,
                        "Pressure": max_pre}}
        return value_return

    @staticmethod
    def get_excel(data_response, condition):
        try:
            df = pd.DataFrame(data_response)
            df.to_excel(f"Weather Report_{condition}.xlsx", index=True)
            return "Dictionary converted into excel..."
        except ValueError:
            raise ValueError
        except Exception as e:
            print(e, "Excel Error Detected")

