from typing import Optional

from pydantic import BaseModel
from sqlalchemy import Column, Integer, String
from sqlalchemy.ext.declarative import declarative_base

from script.core.db.postgresql_connector import engine

Base = declarative_base()


# define a model for Item
class Inventory(Base):
    __tablename__ = 'inventory_data'

    order_id = Column('order_id', Integer, primary_key=True)
    customer_name = Column('customer_name', String, index=True)
    status = Column('status', String)
    sales_order = Column('sales_order', Integer, index=True)


Base.metadata.create_all(engine)


class InventoryData(BaseModel):
    customer_name: str
    status: str
    sales_order: int


class UpdateInventoryData(BaseModel):
    customer_name: Optional[str] = None
    status: Optional[str] = None
    sales_order: Optional[int] = None
