from sqlalchemy import MetaData

from script.core.db.postgresql_connector import session
from script.utils.inventory_utils import SqlUtility

metadata = MetaData()

SqlUtility = SqlUtility()


class PostgresqlCollectRecords:
    @staticmethod
    def create_table():
        try:
            data = SqlUtility.create_file()
            return data
        except Exception as e:
            print(e, "Error detected in creating the table")

    @staticmethod
    def insert_data(request_data):
        try:
            data = SqlUtility.insert_file(request_data)
            session.add(data)
            session.commit()
            return {"order_id": data.order_id, "customer_name": data.customer_name,
                    "status": data.status,
                    "sales_order": data.sales_order}
        except Exception as e:
            print(e, "Error detected in inserting")

    @staticmethod
    def fetch_records():
        try:
            data = SqlUtility.fetch_file()
            return data
        except Exception as e:
            print(e, "Error detected in fetching the data")

    @staticmethod
    def update_records(request_data, order_id):
        try:
            data = SqlUtility.update_file(request_data, order_id)
            session.commit()
            return data
        except Exception as e:
            print(e, "Error detected in updating")

    @staticmethod
    def delete_records(order_id):
        try:
            data = SqlUtility.delete_file(order_id)
            session.delete(data)
            session.commit()
            return data
        except Exception as e:
            print(e, "Error detected in deleting")
