import logging

from fastapi import APIRouter

from script.constants import APIEndpoints
from script.core.errors import ErrorMessage
from script.core.handlers.inventory import PostgresqlCollectRecords
from script.core.schema.inventory import Inventory, InventoryData, UpdateInventoryData
from script.core.schema.responses import DefaultResponse

router = APIRouter(prefix=APIEndpoints.inventory_base)
handler = PostgresqlCollectRecords()


@router.post(APIEndpoints.insert)
async def insert_item(request_data: InventoryData):
    try:
        data = handler.insert_data(request_data)
        return DefaultResponse(message="Successfully inserted", status="success", data = data)
    except ValueError:
        return DefaultResponse(message=ErrorMessage.ERRORS_INSERT)
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="inserted Failed due to server error")


@router.post(APIEndpoints.find)
async def fetch_item():
    try:
        data = handler.fetch_records()
        return DefaultResponse(message="Successfully Found", status="success", data=data)
    except ValueError:
        return DefaultResponse(message=ErrorMessage.ERRORS_FETCH)
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding Failed due to server error")


@router.post(APIEndpoints.update)
async def update_item(order_id: int, request_data: UpdateInventoryData):
    try:
        handler.update_records(request_data, order_id)
        return DefaultResponse(message="Successfully Updated", status="success")
    except ValueError:
        return DefaultResponse(message=ErrorMessage.ERRORS_UPDATE)
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Updation Failed due to server error")


@router.post(APIEndpoints.delete)
async def delete_item(order_id: int):
    try:
        handler.delete_records(order_id)
        return DefaultResponse(message="Successfully deleted", status="success")
    except ValueError:
        return DefaultResponse(message=ErrorMessage.ERRORS_DELETE)
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Deletion failed due to server error")
