from sqlalchemy import Column, Integer, String, MetaData, text
from sqlalchemy import Table

from script.core.db.postgresql_connector import session
from script.core.schema.inventory import Inventory

metadata = MetaData()


class SqlUtility:

    @staticmethod
    def create_file():
        try:
            inventory_table = Table('inventory_data', metadata,
                                    Column('order_id', Integer, primary_key=True, index=True),
                                    Column('customer_name', String),
                                    Column('status', String),
                                    Column('sales_order', Integer, index=True)
                                    )
            return inventory_table
        except Exception as e:
            print(e, "Error detected in updating")

    @staticmethod
    def insert_file(request_data):
        try:
            new_inventory_data = Inventory(customer_name=request_data.customer_name,
                                           status=request_data.status, sales_order=request_data.sales_order)
            return new_inventory_data
        except Exception as e:
            print(e, "Error detected in updating")

    @staticmethod
    def fetch_file():
        try:
            inventory_data = session.query(Inventory).all()
            list_ = []
            for data in inventory_data:
                list_.append({"order_id": data.order_id, "customer_name": data.customer_name, "status": data.status,
                              "sales_order": data.sales_order})
                return list_
        except Exception as e:
            print(e, "Error detected in updating")

    @staticmethod
    def update_file(request_data, order_id):
        try:
            get_update = {key: value for key, value in request_data if
                          value is not None and value != 'string' and value != 0}
            update_data = session.query(Inventory).filter(
                text(str(f"order_id={order_id}"))
            ).update(
                get_update
            )
            return update_data
        except Exception as e:
            print(e, "Error detected in updating")

    @staticmethod
    def delete_file(order_id):
        try:
            data = session.query(Inventory).filter_by(order_id=order_id).first()
            return data
        except Exception as e:
            print(e, "Error detected in updating")
