import json
from datetime import datetime
import paho.mqtt.client as mqtt
from script.db.mongo_connection import mongo_connection
from script.config.app_config import Service

# subscribe


topic1 = "test/#"


class MqttConnectMongodb:
    try:
        @staticmethod
        def mqtt_file():
            def on_connect(client, userdata, flags, rc):
                print("Connected to MQTT broker with result code " + str(rc))
                client.subscribe(topic1)

            def on_message(client_id, userdata, msg):
                print(
                    "Received message on topic '" + msg.topic + "' with message '" + msg.payload.decode('utf-8') + "'")

                db = mongo_connection['interns_b2_23']
                collection = db['Vipul-data']
                data = json.loads(msg.payload.decode('utf-8'))
                document = {'topic': msg.topic, 'payload': data}
                data.update({"Recevied message at": datetime.utcnow().isoformat()})
                result = collection.insert_one(document)
                print("Saved message to MongoDB with ID " + str(result.inserted_id))

            client = mqtt.Client()
            client.on_connect = on_connect
            client.on_message = on_message
            client.connect(Service().host, Service().port)
            client.loop_forever()

    except ValueError:
        raise ValueError
    except Exception as e:
        print(e, "Excel Error Detected")