import os
from dotenv import load_dotenv
from configparser import SafeConfigParser

config = SafeConfigParser()
config.read('conf/application.conf')
load_dotenv()


class Service:
    port = int(config.get("MQTT_SERVICE", "broker_port"))
    host = config.get("MQTT_SERVICE", "broker_host")


class Mongo:
    mongo_uri: str = os.environ.get("CLIENT")
