import json

import paho.mqtt.client as mqtt

from script.config.app_confing import Services
from script.core.db.postgresql_connector import session
from script.core.schema.schema_file import Items, InvoiceDetails

# subscribe


topic = "test/#"


class MqttConnectPostgresql:
    try:
        @staticmethod
        def mqtt_file():
            def on_connect(client, userdata, flags, rc):
                print("Connected to MQTT broker with result code " + str(rc))
                client.subscribe(topic)

            def on_message(client, userdata, msg):
                print(
                    "Received message on topic '" + msg.topic + "' with message '" + msg.payload.decode('utf-8') + "'")
                data = json.loads(msg.payload.decode('utf-8'))
                print(data)
                for invoice in data:
                    invoice_number = invoice['invoice_number']
                    client_name = invoice['client_name']
                    invoice_date = invoice['invoice_date']
                    due_date = invoice['due_date']
                    subtotal = invoice['subtotal']
                    tax_rate = invoice['tax_rate']
                    total = invoice['total']
                    paid = invoice['paid']

                    if paid:
                        payment_date = invoice['payment_date']
                        payment_method = invoice['payment_method']
                        billing_address = payment_method['billing_address']

                        invoice_data = InvoiceDetails(
                            invoice_number=invoice_number,
                            client_name=client_name,
                            invoice_date=invoice_date,
                            due_date=due_date,
                            subtotal=subtotal,
                            tax_rate=tax_rate,
                            total=total,
                            paid=paid,
                            payment_date=payment_date,
                            payment_method=payment_method,
                            billing_address=billing_address
                        )
                    else:
                        invoice_data = InvoiceDetails(
                            invoice_number=invoice_number,
                            client_name=client_name,
                            invoice_date=invoice_date,
                            due_date=due_date,
                            subtotal=subtotal,
                            tax_rate=tax_rate,
                            total=total,
                            paid=paid
                        )
                    session.add(invoice_data)
                    session.flush()
                    invoice_id = invoice_data.id
                    for item_data in invoice['items']:
                        item = Items(
                            invoice_id=invoice_id,
                            description=item_data['description'],
                            quantity=item_data['quantity'],
                            price=item_data['price']
                        )
                        session.add(item)
                session.commit()

            client = mqtt.Client()
            client.on_connect = on_connect
            client.on_message = on_message
            client.connect(Services().host, Services().port)
            client.loop_forever()

    except Exception as e:
        print(e, "Error detected in subscribe")

