from dotenv import load_dotenv
import os
from configparser import SafeConfigParser

load_dotenv()
config = SafeConfigParser()
config.read('conf/application.conf')


class Sql:

    postgresql: str = os.environ.get("POSTGRESQL_URI")


class Services:
    host = config.get("MQTT_SERVICE", "broker_host")
    port = int(config.get("MQTT_SERVICE", "broker_port"))