import json

import paho.mqtt.client as mqtt
from sqlalchemy.orm import sessionmaker

from script.config.app_confing import Services
from script.core.db.postgresql_connector import engine
from script.core.schema.schema_file import Items, InvoiceDetails

Session = sessionmaker(bind=engine)

topic = "test/#"


class MqttConnectPostgresql:
    try:
        @staticmethod
        def mqtt_file():
            def on_connect(client, userdata, flags, rc):
                print("Connected to MQTT broker with result code " + str(rc))
                client.subscribe(topic)

            def on_message(client, userdata, msg):
                print(
                    "Received message on topic '" + msg.topic + "' with message '" + msg.payload.decode('utf-8') + "'")
                data = json.loads(msg.payload.decode('utf-8'))
                invoices = []
                items = []

                for invoice in data:
                    invoice_data = InvoiceDetails(
                        invoice_number=invoice['invoice_number'],
                        client_name=invoice['client_name'],
                        invoice_date=invoice['invoice_date'],
                        due_date=invoice['due_date'],
                        subtotal=invoice['subtotal'],
                        tax_rate=invoice['tax_rate'],
                        total=invoice['total'],
                        paid=invoice['paid'],
                        payment_date=invoice.get('payment_date'),
                        payment_method=invoice.get('payment_method')
                    )
                    invoices.append(invoice_data)
                    with Session() as session:
                        session.add(invoice_data)
                        session.commit()
                        invoice_id = invoice_data.id
                    for item_data in invoice['items']:
                        item = Items(
                            invoice_id=invoice_id,
                            description=item_data['description'],
                            quantity=item_data['quantity'],
                            price=item_data['price']
                        )
                        items.append(item)

                with Session() as session:
                    session.bulk_save_objects(items)
                    session.commit()

            client = mqtt.Client()
            client.on_connect = on_connect
            client.on_message = on_message
            client.connect(Services().host, Services().port)
            client.loop_forever()

    except Exception as e:
        print(e, "Error detected in subscribe")