from sqlalchemy import MetaData, inspect

from script.core.db.postgresql_connector import session, engine
from script.core.schema.schema_file import InvoiceDetails, Items

metadata = MetaData()


class SqlUtility:

    @staticmethod
    def fetch_file():
        try:
            inspector = inspect(engine)
            columns = inspector.get_columns('invoice_details')
            column_names = [c['name'] for c in columns]
            invoice_details = session.query(InvoiceDetails).all()
            body = []
            for data in invoice_details:
                row = {}
                for column_name in column_names:
                    row[column_name] = getattr(data, column_name)
                body.append(row)
            header = []
            for column_name in column_names:
                title_name = column_name.replace('_', ' ').title()
                header.append({"label": title_name, "value": column_name})

            columns2 = inspector.get_columns('items')
            column_names2 = [c['name'] for c in columns2]
            items = session.query(Items).all()
            body2 = []
            for data in items:
                row = {}
                for column_name in column_names2:
                    row[column_name] = getattr(data, column_name)
                body2.append(row)
            header2 = []
            for column_name in column_names2:
                title_name = column_name.replace('_', ' ').title()
                header2.append({"label": title_name, "value": column_name})

            return {"headerContent": header, "bodyContent": body, "headerContent2": header2, "bodyContent2": body2}
        except Exception as e:
            print(e, "Error detected in updating")
