import logging

from fastapi import APIRouter

from script.constants import APIEndpoints
from script.core.errors import ErrorMessage
from script.core.handlers.handler_file import FetchRecords
from script.core.schema.responses import DefaultResponse

router = APIRouter(prefix=APIEndpoints.fetch_records)
handler = FetchRecords()


@router.post(APIEndpoints.find)
async def fetch_item():
    try:
        data = handler.fetch_records()
        return DefaultResponse(message="Successfully Found", status="success", data=data)
    except ValueError:
        return DefaultResponse(message=ErrorMessage.ERRORS_FETCH)
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding Failed due to server error")