from sqlalchemy import Column, Integer, String, Date, Float, Boolean, ForeignKey
from sqlalchemy.dialects.postgresql import JSONB
from sqlalchemy.ext.declarative import declarative_base

from script.core.db.postgresql_connector import engine

Base = declarative_base()


class InvoiceDetails(Base):
    __tablename__ = 'invoice_details'

    id = Column('id', Integer, primary_key=True, autoincrement=True)
    invoice_number = Column('invoice_number', String, unique=True)
    client_name = Column('client_name', String)
    invoice_date = Column('invoice_date', Date)
    due_date = Column('due_date', Date)
    subtotal = Column('subtotal', Integer)
    tax_rate = Column('tax_rate', Float)
    total = Column('total', Float)
    paid = Column('paid', Boolean)
    payment_date = Column('payment_date', Date)
    payment_method = Column('payment_method', JSONB)


class Items(Base):
    __tablename__ = 'items'
    id = Column('id', Integer, primary_key=True, autoincrement=True)
    invoice_id = Column("invoice_id", ForeignKey(InvoiceDetails.id), nullable=False)
    description = Column('description', String)
    quantity = Column('quantity', Integer)
    price = Column('price', Integer)


Base.metadata.create_all(engine)
