import logging

from fastapi.routing import APIRouter

from script.constants import APIEndpoints
from script.core.handlers.inventory import InventoryData
from script.core.schema.inventory import Inventory
from script.core.schema.responses import DefaultResponse

router = APIRouter(prefix=APIEndpoints.inventory_base)
handler = InventoryData()


@router.post(APIEndpoints.delete)
async def delete_item(order_id: int):
    """This API deletes an item"""
    try:
        handler.delete_data(order_id, int)
        return DefaultResponse(message="Successfully deleted", status="success")
    except ValueError:
        return DefaultResponse(message="Due to Value Error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Deletion failed due to server error")


@router.post(APIEndpoints.update)
async def update_item(order_id: int):
    try:
        handler.update_data(order_id, int)
        return DefaultResponse(message="Successfully Updated", status="success")
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Updation Failed due to server error")


@router.get(APIEndpoints.find)
async def find_item(order_id: int):
    try:
        handler.find_data(order_id, int)
        return DefaultResponse(message="Successfully Found", status="success")
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Finding Failed due to server error")


@router.post(APIEndpoints.insert)
async def insert_item(request_data: Inventory):
    try:
        handler.insert_data(request_data)
        return DefaultResponse(message="Successfully inserted", status="success")
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="inserted Failed due to server error")
