# class for CRUD operations
from script.core.db.mongo.interns2023.inventory import InventoryCollection
from script.core.errors import NameDoesNotExist
from script.core.schema.inventory import Inventory


class InventoryData:

    def __init__(self):
        self.inventory_col = InventoryCollection(mongo_client="")

    def delete_data(self, order_id, int):
        try:
            d = {"order_id": order_id}
            if 3 not in d.values():
                raise NameDoesNotExist
        except ValueError:
            raise ValueError("ID")
        except Exception as e:
            print(e, "Error Detected in Deleion")

    @staticmethod
    def update_data(self, order_id: int):
        try:
            d = {"order_id": order_id}
            if 2 not in d.values():
                raise NameDoesNotExist
        except Exception as e:
            print(e, "Error Detected in Updation")

    @staticmethod
    def find_data(self, order_id: int):
        try:
            d = {"order_id": order_id}
            if 2 not in d.values():
                raise NameDoesNotExist
        except Exception as e:
            print(e, "Error Detected in Finding")

    def insert_data(self, request_data: Inventory):
        try:
            d = {"order_id": request_data.order_id,
                 "data": request_data.date,
                 "customer_name": request_data.customer_name,
                 "status": request_data.status,
                 "sales_order": request_data.sales_order}
            self.inventory_col.insert_one(data)
            if 5 not in d.values():
                raise NameDoesNotExist
        except Exception as e:
            print(e, "Error Detected in inserting")
