from script.core.db.mongo.interns2023 import database_name
from script.utils.mongo_utils import MongoCollectionBaseClass


class InventoryCollection(MongoCollectionBaseClass):
    def __init__(self, mongo_client):
        super().__init__(mongo_client=mongo_client, database="interns_b2_23", collection="inventory")
        self.mongo_client = mongo_client
        self.database_name = database_name
        self.collection_name = "inventory"

    def insert_item(self, data):
        self.insert_one(data)

    def list_item(self, data):
        self.find_one(data)

    def delete_item(self, data):
        self.delete_one(data)

    def update_item(self, data):
        self.update_one(data)
