# class for CRUD operations
from script.core.db.mongo.interns2023 import mongo_client
from script.core.db.mongo.interns2023.inventory import InventoryCollection
from script.core.schema.inventory import Inventory


class InventoryData:

    def __init__(self):
        self.inventory_col = InventoryCollection(mongo_client=mongo_client)

    def delete_data(self, order_id):
        try:
            self.inventory_col.delete_one(query={"order_id": order_id})
        except ValueError:
            raise ValueError("ID")
        except Exception as e:
            print(e, "Error Detected in Deletion")

    def update_data(self, request_data: Inventory):
        try:
            d = {"order_id": request_data.order_id,
                 "customer_name": request_data.customer_name,
                 "date": request_data.date,
                 "status": request_data.status,
                 "sales_order": request_data.sales_order}
            self.inventory_col.update_one(query={"order_id": request_data.order_id}, data=d)
        except Exception as e:
            print(e, "Error Detected in Updation")

    def find_data(self, order_id: int):
        try:
            data = self.inventory_col.find_one(query={"order_id": order_id})
            return data
        except Exception as e:
            print(e, "Error Detected in Finding")

    def insert_data(self, request_data: Inventory):
        try:
            d = {"order_id": request_data.order_id,
                 "customer_name": request_data.customer_name,
                 "date": request_data.date,
                 "status": request_data.status,
                 "sales_order": request_data.sales_order}
            self.inventory_col.insert_one(d)
        except Exception as e:
            print(e, "Error Detected in inserting")
