# class for CRUD operations
from datetime import datetime

from script.core.db.mongo.interns2023 import mongo_client
from script.core.db.mongo.interns2023.inventory import InventoryCollection
from script.core.schema.inventory import Inventory


class InventoryData:

    def __init__(self):
        self.inventory_col = InventoryCollection(mongo_client=mongo_client)

    def insert_data(self, request_data: Inventory):
        try:
            d = {"order_id": request_data.order_id,
                 "customer_name": request_data.customer_name,
                 "date": datetime.now(),
                 "status": request_data.status,
                 "sales_order": request_data.sales_order}

            self.inventory_col.insert_one(d)
        except Exception as e:
            print(e, "Error Detected in inserting")

    def aggregate_data(self, order_id):
        try:
            pipeline = [
                {
                    "$match":

                        {
                            "order_id": order_id,
                        },
                },
                {
                    "$sort":
                        {
                            "customer_name": -1,
                        },
                },
                {
                    "$limit": 2
                },
                {
                    "$project":
                        {
                            "customer_name": "$customer_name",
                            "_id": 0,
                        }

                }
            ]

            data = self.inventory_col.aggregate(pipeline)
            list_ = []
            for i in data:
                list_.append(i)
            return list_
        except Exception as e:
            print(e)
