import logging

from fastapi.routing import APIRouter

from script.constants import APIEndpoints
from script.core.handlers.inventory import InventoryData
from script.core.schema.inventory import Inventory
from script.core.schema.responses import DefaultResponse

router = APIRouter(prefix=APIEndpoints.inventory_base)
handler = InventoryData()


@router.post(APIEndpoints.insert)
async def insert_item(request_data: Inventory):
    try:
        handler.insert_data(request_data)
        return DefaultResponse(message="Successfully inserted", status="success")
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="inserted Failed due to server error")

@router.get(APIEndpoints.aggregate)
async def aggregate_item(order_id: int):
    try:
        data = handler.aggregate_data(order_id)
        return DefaultResponse(message="Successfully found", status="success", data=data)
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="inserted Failed due to server error")