import logging

from fastapi import APIRouter

from scripts.constants import APIEndpoints
from scripts.core.errors import ErrorMessage
from scripts.core.handler.pos_agg import PostgreSQL
from scripts.core.schema.pos_agg import studentData, studentDetails
from scripts.core.schema.responses import DefaultResponse

router = APIRouter(prefix=APIEndpoints.student_base)
handler = PostgreSQL()


@router.post(APIEndpoints.insert)
async def insert_student(request_data: studentData):
    try:
        data = handler.insert_data(request_data)
        return DefaultResponse(message="Successfully inserted", status="success", data=data)
    except ValueError:
        return DefaultResponse(message=ErrorMessage.ERRORS_INSERT)
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Failed to Insert data")


@router.post(APIEndpoints.find)
async def fetch_student():
    try:
        data = handler.fetch_data()
        return DefaultResponse(message="Successfully Found", status="success", data=data)
    except ValueError:
        return DefaultResponse(message=ErrorMessage.ERRORS_FETCH)
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Failed to Find the data")


@router.post(APIEndpoints.update)
async def update_student(student_id: int, request_data: studentDetails):
    try:
        handler.update_data(request_data,student_id)
        return DefaultResponse(message="Successfully Updated", status="success")
    except ValueError:
        return DefaultResponse(message=ErrorMessage.ERRORS_UPDATE)
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Failed to Update the data")


@router.post(APIEndpoints.delete)
async def delete_student(student_id: int):
    try:
        handler.delete_data(student_id)
        return DefaultResponse(message="Successfully deleted", status="success")
    except ValueError:
        return DefaultResponse(message=ErrorMessage.ERRORS_DELETE)
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Failed to Delete the data")
