from typing import Optional

from pydantic import BaseModel
from sqlalchemy import Column, Integer, String
from sqlalchemy.ext.declarative import declarative_base

from scripts.core.db.database import engine

Base = declarative_base()


# define a model for Item
class student(Base):
    __tablename__ = 'Students_Records'
    student_id = Column('student_id', Integer, primary_key=True)
    student_name = Column('student_name', String, index=True)
    description = Column('description', String)
    address = Column('address', String)

Base.metadata.create_all(engine)


class studentData(BaseModel):
    student_name: str
    description: str
    address: int


class studentDetails(BaseModel):
    student_name: Optional[str] = None
    description: Optional[str] = None
    address: Optional[int] = None
