from sqlalchemy import Column, Integer, String, MetaData, text
from sqlalchemy import Table

from scripts.core.db.database import session
from scripts.core.schema.pos_agg import student

metadata = MetaData()


class SqlUtility:

    @staticmethod
    def create_table():
            try:
                student_table = Table('student_data', metadata,
                                      Column('student_id', Integer, primary_key=True, index=True),
                                      Column('student_name', String),
                                      Column('description', String),
                                      Column('address', String)
                                      )
                return student_table
            except Exception as e:
                print(e, "Failed to create table")

    @staticmethod
    def insert_data(request_data):
        try:
            new_student_data = student(student_name=request_data.student_name, description=request_data.description,
                                       address=request_data.address)
            return new_student_data
        except Exception as e:
            print(e, "Failed to Insert data")

    @staticmethod
    def delete_data(student_id):
        try:
            data = session.query(student).filter_by(stuent_id=student_id).first()
            return data
        except Exception as e:
            print(e, "Failed to delete data")

    @staticmethod
    def update_data(request_data, student_id):
        try:
            get_update = {key: value for key, value in request_data if
                          value is not None and value != 'string' and value != 0}
            update_data = session.query(student).filter(
                text(str(f"student_id={student_id}"))
            ).update(
                get_update
            )
            return update_data
        except Exception as e:
            print(e, "failed to update the data")

    @staticmethod
    def fetch_data():
        try:
            student_data = session.query(student).all()
            list_ = []
            for data in student_data:
                list_.append(
                    {"student_id": data.student_id, "student_name": data.student_name, "desciption": data.description,
                     "address": data.address})
            return list_
        except Exception as e:
            print(e, "Failed to Find the data")