from sqlalchemy import Column, Integer, String, MetaData, text
from sqlalchemy import Table

from scripts.core.db.database import session
from scripts.core.schema.pos_agg import student

metadata = MetaData()


class PostgreSQL:
    @staticmethod
    def create_table():
        try:
            student_table = Table('student_data', metadata,
                                  Column('student_id', Integer, primary_key=True, index=True),
                                  Column('student_name', String),
                                  Column('description', String),
                                  Column('address', String)
                                  )
            return student_table
        except Exception as e:
            print(e, "Failed to create table")

    @staticmethod
    def insert_data(request_data):
        try:
            new_student_data = student(student_name=request_data.student_name, description=request_data.description,
                                       address=request_data.address)
            session.add(new_student_data)
            session.commit()
            return {"student_id": new_student_data.student_id, "student_name": new_student_data.student_name,
                    "description": new_student_data.desciption,
                    "address": new_student_data.address}
        except Exception as e:
            print(e, "Failed to Insert data")

    @staticmethod
    def delete_data(student_id):
        try:
            data = session.query(student).filter_by(stuent_id=student_id).first()
            session.delete(data)
            session.commit()
            return data
        except Exception as e:
            print(e, "Failed to delete data")

    @staticmethod
    def update_data(request_data, student_id):
        try:
            get_update = {key: value for key, value in request_data if
                          value is not None and value != 'string' and value != 0}
            update_data = session.query(student).filter(
                text(str(f"student_id={student_id}"))
            ).update(
                get_update
            )
            session.commit()
            print(update_data)
            return update_data
        except Exception as e:
            print(e, "failed to update the data")

       @staticmethod
    def fetch_data():
        try:
            fetch_data = SqlUtility.fetch_file()
            header_label = [" ".join(col.split("_")).title() for col in student.__table__.columns.keys()]
            header_value = list(student.__table__.columns.keys())

            header = [{"label": label, "value": value} for label, value in zip(header_label, header_value)]

            response = {
                "header": header,
                "body content": fetch_data
            }
            return response
        except Exception as e:
            print(e, "failed to find the data")