import pymongo
import json
from datetime import datetime
from scripts.core.interns.connection import MONGODB_COLLECTION,MONGODB_DATABASE,MONGODB_URI

# Define function to insert a document into MongoDB
def insert_to_mongodb(document, collection_name):
    # Connect to MongoDB
    mongo_client = pymongo.MongoClient(MONGODB_URI)
    db = mongo_client[MONGODB_DATABASE]
    collection = db[collection_name]

    # Insert the document into MongoDB
    collection.insert_one(document)
    print("Message inserted into MongoDB")


# Define callback function for when a message is received
def on_message(client, userdata, message):
    received_message = message.payload.decode()

    # Extract humidity, temperature, and windspeed values from the message payload
    payload = json.loads(received_message)
    humidity = payload["humidity"]
    temperature = payload["temperature"]
    windspeed = payload["windspeed"]

    # Print the received message and extracted values
    print("Received message:", received_message)
    print("Humidity:", humidity)
    print("Temperature:", temperature)
    print("Windspeed:", windspeed)

    # Create document to insert into MongoDB
    document = {
        "message": received_message,
        "timestamp": datetime.utcnow(),
        "topic": message.topic,
        "humidity": humidity,
        "temperature": temperature,
        "windspeed": windspeed
    }